#include <iostream>
#include <algorithm>

struct Exp
{
    int t, x;
    Exp(int tt = -1, int xt = 0) : t{tt}, x{xt}
    {}
    bool operator < (const Exp& b)
    {
        return t < b.t || (t == b.t && x < b.x);
    }
};

int abs(int n);
int min(int a, int b);
int max(int a, int b);

int main()
{
    int n;
    scanf("%d", &n);
    Exp t[n];
    for (int i = 0; i < n; i++) scanf("%d %d", &t[i].t, &t[i].x);
    std::sort(t, t + n);
    if (t[0].t == t[n - 1].t)
    {
        int i = 0;
        while (abs(t[i].x) > t[0].t) i++;
        int res = i > 0 ? min((t[i].x - t[i - 1].x) / 2, abs(t[i].x - t[0].t)) : min(abs(t[0].t - t[0].x), abs(t[0].t + t[0].x));
        i++;
        for (i; i < n && abs(t[i].x) <= t[0].t; i++)
            if ((t[i].x - t[i - 1].x) / 2 > res) res = (t[i].x - t[i - 1].x) / 2;
        if (i < n && min((t[i].x - t[i - 1].x) / 2, abs(t[i].x - t[0].t)) > res) res = min((t[i].x - t[i - 1].x) / 2, abs(t[i].x - t[0].t));
        else if (min(abs(t[0].t - t[n - 1].x), abs(t[0].t + t[n - 1].x)) > res) res = min(abs(t[0].t - t[n - 1].x), abs(t[0].t + t[n - 1].x));
        printf("%d", res);
    }
    return 0;
}


int abs(int n)
{
    return n > 0 ? n : -n;
}


int min(int a, int b)
{
    return a < b ? a : b;
}


int max(int a, int b)
{
    return a > b ? a : b;
}
